PROGRAM power
!
!  Purpose: 
!    To calculate the current, real, reactive, and apparent power,
!    and the power factor supplied to a load. 
!
!  Record of revisions:
!      Date       Programmer          Description of change
!      ====       ==========          =====================
!    09/03/95    S. J. Chapman        Original code 
!
     
IMPLICIT NONE
 
!  Declare the constants used in this program.  
REAL, PARAMETER :: conv = 0.01745329 ! Degrees to radians cnv factor

!  Declare the variables used in this program.  
REAL :: amps            ! Current in the load
REAL :: p               ! Real power of load
REAL :: pf              ! Power factor of load
REAL :: q               ! Reactive power of the load
REAL :: s               ! Apparent power of the load
REAL :: theta           ! Impedance angle of the load
REAL :: volts           ! Rms voltage of the power source
REAL :: z               ! Magnitude of the impedance of the load

! Prompt the user for the rms voltage.
WRITE (*,*) 'Enter the rms voltage of the source: '
READ  (*,*) volts 

! Prompt the user for the magnitude and angle of the impedance.
WRITE (*,*) 'Enter the magnitude and angle of the impedance '
WRITE (*,*) 'in ohms and degrees: '
READ  (*,*) z, theta   

! Perform calculations
amps = volts / z                        ! Rms current
p = volts * amps * cos (theta * conv)   ! Real power
q = volts * amps * sin (theta * conv)   ! Reactive power
s = volts * amps                        ! Apparent power
pf = cos ( theta * conv)                ! Power factor
 
! Write out the results.
WRITE (*,*) 'Voltage        = ', volts, ' volts'
WRITE (*,*) 'Impedance      = ', z, ' ohms at ', theta,' degrees'
WRITE (*,*) 'Current        = ', amps, ' amps'
WRITE (*,*) 'Real Power     = ', p, ' watts'
WRITE (*,*) 'Reactive Power = ', q, ' VAR'
WRITE (*,*) 'Apparent Power = ', s, ' VA'
WRITE (*,*) 'Power Factor   = ', pf
 
! Finish up.
END PROGRAM
